<?PHP

/**
	* Establish Database Connection
	*/
	function connect() {
		require_once 'config/config.php';
		$connect = mysqli_connect(DB_HOST, DB_USER, DB_PASS, DB_NAME);
		if (!$connect) header('Location:setup.php');
		mysqli_set_charset($connect, 'utf8');
		return $connect;
	}

/**
	* Generate unique fingerprint for every user session
	* @return string fingerprint : Unique fingerprint generated from remote server address,
	* random string, and user agent
	*/
	function fingerprint(){
		return $fingerprint = md5($_SERVER['REMOTE_ADDR'].'jikI/20Y,!'.$_SERVER['HTTP_USER_AGENT']);
	}

/**
	* Check if current user is logged in
	*/
	function checkLogin() {
		$fingerprint = fingerprint();
		session_start();
		if (!isset($_SESSION['log_user']) || $_SESSION['log_fingerprint'] != $fingerprint) logout();
		session_regenerate_id();
	}

/**
	* Check if current user logged out properly last time
	*/
	function checkLogout(){
		if ($_SESSION['logrec_logout'] == 0){
			showMessage("You forgot to logout last time. Please remember to log out properly.");
			$_SESSION['logrec_logout'] = 1;
		}
	}

/**
	* Check if current user has Admin permission
	*/
	function checkPermissionAdmin() {
		if ($_SESSION['log_admin']!=='1'){
			header('Location: start.php');
			die();
		}
	}

/**
	* Check if current user has Delete permission
	*/
	function checkPermissionDelete() {
		if ($_SESSION['log_delete']!=='1'){
			header('Location: start.php');
			die();
		}
	}

/**
	* Check if current user has permission to access Reports
	*/
	function checkPermissionReport() {
		if ($_SESSION['log_report']!=='1'){
			header('Location: start.php');
			die();
		}
	}

	/**
	* Logout procedure: Delete session variables
	* and cookies, destroy user session.
	*/
	function logout(){
		/* Delete all Session Variables */
		$_SESSION = array();

		/* If a session cookie was used, delete it */
		if (ini_get("session.use_cookies")) {
			$params = session_get_cookie_params();
			setcookie(session_name(), '', time() - 86400, $params["path"], $params["domain"], $params["secure"], $params["httponly"]);
		}

		/* Finally, delete the Session */
		session_destroy();

		/* Forward to logout_success.php */
        /* Edit Forward to index.php */
		header('Location: index.php'); /* header('Location: logout_success.php'); */
		die;
	}

/**
	* Check if an SQL statement has succeded
	*/
	function checkSQL($db_link, $sqlquery){
		if (!$sqlquery) die ('SQL-Statement failed: '.mysqli_error($db_link));
	}

/**
	* Pushing system settings into session variables
	*/
	function getSettings($db_link){
		$sql_settings = "SELECT * FROM settings";
		$query_settings = mysqli_query($db_link, $sql_settings);
		checkSQL($db_link, $query_settings, $db_link);
		while($row_settings = mysqli_fetch_assoc($query_settings)){

			switch ($row_settings['set_short']){
				case "SET_MSB":
					$_SESSION['set_msb'] = $row_settings['set_value'];
					break;
				case "SET_MLP":
					$_SESSION['set_minlp'] = $row_settings['set_value'];
					break;
				case "SET_XLP":
					$_SESSION['set_maxlp'] = $row_settings['set_value'];
					break;
				case "SET_CUR":
					$_SESSION['set_cur'] = $row_settings['set_value'];
					break;
				case "SET_AUF":
					$_SESSION['set_auf'] = $row_settings['set_value'];
					break;
				case "SET_DEA":
					$_SESSION['set_deact'] = $row_settings['set_value'];
					break;
				case "SET_DBL":
					$_SESSION['set_dashl'] = $row_settings['set_value'];
					break;
				case "SET_DBR":
					$_SESSION['set_dashr'] = $row_settings['set_value'];
					break;
				case "SET_ICL":
					$_SESSION['set_intcalc'] = $row_settings['set_value'];
					break;
				case "SET_GUA":
					$_SESSION['set_maxguar'] = $row_settings['set_value'];
					break;
				case "SET_MEM":
					$_SESSION['set_minmemb'] = $row_settings['set_value'];
					break;
				case "SET_PSR":
					$_SESSION['set_maxpsr'] = $row_settings['set_value'];
					break;
				case "SET_CNO":
					$_SESSION['set_cno'] = $row_settings['set_value'];
					break;
				case "SET_XL1":
					$_SESSION['set_xl1'] = $row_settings['set_value'];
					break;
				case "SET_ENO":
					$_SESSION['set_eno'] = $row_settings['set_value'];
					break;
				case "SET_SFX":
					$_SESSION['set_sfx'] = $row_settings['set_value'];
					break;
				case "SET_CSI":
					$_SESSION['set_csi'] = $row_settings['set_value'];
					break;
				case "SET_F4F":
					$_SESSION['set_f4f'] = $row_settings['set_value'];
					break;
			}
		}
	}

/**
	* Pushing fee settings into session variables
	*/
	function getFees($db_link){
		$sql_fees = "SELECT * FROM fees";
		$query_fees = mysqli_query($db_link, $sql_fees);
		checkSQL($db_link, $query_fees, $db_link);
		while ($row_fees = mysqli_fetch_assoc($query_fees)){
			switch ($row_fees['fee_short']){
				case "FEE_ENT":
					$_SESSION['fee_entry'] = $row_fees['fee_value'];
					break;
				case "FEE_WDL":
					$_SESSION['fee_withdraw'] = $row_fees['fee_value'];
					break;
				case "FEE_STS":
					$_SESSION['fee_stationary'] = $row_fees['fee_value'];
					break;
				case "FEE_ASB":
					$_SESSION['fee_subscr'] = $row_fees['fee_value'];
					break;
				case "FEE_LOF":
					$_SESSION['fee_loan'] = $row_fees['fee_value'];
					break;
				case "FEE_LAP":
					$_SESSION['fee_loanappl'] = $row_fees['fee_value'];
					break;
				case "FEE_LDF":
					$_SESSION['fee_loanfine'] = $row_fees['fee_value'];
					break;
				case "FEE_LIR":
					$_SESSION['fee_loaninterestrate'] = $row_fees['fee_value'];
					break;
				case "FEE_INS":
					$_SESSION['fee_loaninsurance'] = $row_fees['fee_value'];
					break;
				case "FEE_XL1":
					$_SESSION['fee_xl1_name'] = $row_fees['fee_name'];
					$_SESSION['fee_xl1'] = $row_fees['fee_value'];
					break;
			}
		}
	}

/**
	* Pushing current share value into a session variable
	*/
	function getShareValue($db_link){
		$sql_shareval = "SELECT shareval_value FROM shareval WHERE shareval_id IN (SELECT MAX(shareval_id) FROM shareval)";
		$query_shareval = mysqli_query($db_link, $sql_shareval);
		checkSQL($db_link, $query_shareval, $db_link);
		$result_shareval = mysqli_fetch_assoc($query_shareval);
		$_SESSION['share_value'] = $result_shareval['shareval_value'];
	}

/**
	* Sanitize and secure user input
	* @param string var : User Input
	* @return string var : Secured and sanitized User Input
	*/
	function sanitize($db_link, $var) {
		if(get_magic_quotes_gpc()) $var = stripslashes($var);
		$var = htmlentities($var);
		$var = strip_tags($var);
		$var = mysqli_real_escape_string($db_link, $var);
		return $var;
	}

/**
	* Convert a number of days into UNIX timestamp seconds
	* @param int days : Number of days
	* @return int seconds : Lenght of number of days in seconds
	*/
	function convertDays($days){
		return $seconds = $days * 86400;
	}

/**
	* Convert a number of months into UNIX timestamp seconds
	* @param int months : Number of months
	* @return int seconds : Lenght of number of days in seconds
	*/
	function convertMonths($months){
		return $seconds = $months * 2635200; // Seconds for 30.5 days
	}

/**
	* Check if a GET parameter with a Customer ID has been set
	* If not, return to start page.
	*/
	function getCustID($db_link){
		if (isset($_GET['cust'])) $_SESSION['cust_id'] = sanitize($db_link, $_GET['cust']);
		else header('Location: start.php');
	}

/**
	* Check if a GET parameter with a Loan ID has been set
	* If not, return to customer page.
	*/
	function getLoanID($db_link){
		if (isset($_GET['lid'])) $_SESSION['loan_id'] = sanitize($db_link, $_GET['lid']);
		else header('Location: customer.php?cust='.$_SESSION['cust_id']);
	}

/**
	* Generate HTML Header Section
	* @param string title : Page title
	* @param int endFlag : Flag to indicate whether or not to end header section.
	*/
	function includeHead($title, $endFlag = 1) {
		echo '<head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="robots" content="noindex, nofollow">
		<title>ATC Microfinance | '.$title.'</title>
        <link rel="icon" type="image/x-icon" href="ico/favicon.ico">
        
        <!-- CSS -->
        <link rel="stylesheet" href="css/atcMFMainStyle.css" />
        <!-- fonts :google,fontawesome -->
        <link rel="stylesheet" href="https://fonts.googleapis.com/css?family=Raleway">
        <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.2.0/css/all.css">
        <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.2.0/css/fontawesome.css">
        <link rel="stylesheet" href="ico/font-awesome/css/font-awesome.min.css">
		<link rel="stylesheet" href="jquery/jquery-ui-1.11.4/jquery-ui.min.css">
           
            <script src="jquery/jquery-2.2.1.min.js"></script>
			<script src="jquery/jquery-ui-1.11.4/jquery-ui.min.js"></script>
            
            <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
            <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
            
            <!-- Auto compleat drop down js -->
            <script src="https://code.jquery.com/jquery-1.12.4.js"></script>
            <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
            
            
            <!-- tables pagination --> 
           

			<script>
				$(function() {
					$("#datepicker, #datepicker2, #datepicker3").datepicker({
						showOtherMonths: true,
						selectOtherMonths: true,
						dateFormat: \'dd.mm.yy\',
						changeMonth: true,
						changeYear: true
					});
				});
			</script>
			';
		if ($endFlag == 1) echo '</head>';
	}

/**
	* Generate Menu bar
	* @param int tab_no : Number of currently selected menu tab.
	*/
	function includeMenu($tab_no){
		echo '
		<!-- MENU HEADER -->
        <div id="topbarATCmf">
            <div>
				<strong id="topbarATCmfCname">
                    <a href="https://atctechnologies.lk/" target="_blank" style=" text-decoration: none !important; color:white;">ATC Microfinance</a>
                </strong>
                    
                <span>'.$_SESSION['log_user'].' | <a href="logout.php">Logout</a> 
                </span>
                
            </div>
		</div>';
        
        echo '
        <!-- MENU TABS -->
        <div id="menu_tabs2">
           <section id="sectionMainNav">
            <div class="mainLogoNav" id="mainLogoNav">
                <a href="start.php">
                    Company Name
               <!-- <img src="ico/mainBodyLogo.png"> -->
                </a>
            </div>
            <nav class="mainNav">
                <a href="start.php"> 
                <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 512 512"><style>svg{fill:#ffffff}</style><path d="M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM288 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM256 416c35.3 0 64-28.7 64-64c0-17.4-6.9-33.1-18.1-44.6L366 161.7c5.3-12.1-.2-26.3-12.3-31.6s-26.3 .2-31.6 12.3L257.9 288c-.6 0-1.3 0-1.9 0c-35.3 0-64 28.7-64 64s28.7 64 64 64zM176 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM96 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm352-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"/></svg>
                Dashboard</a>';
                
                if ($_SESSION['UGroup_id'] == 1 OR $_SESSION['UGroup_id'] == 2 OR $_SESSION['UGroup_id'] == 3 OR $_SESSION['UGroup_id'] == 5){
                echo'
                <a href="cust_search.php">
                <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 640 512"><style>svg{fill:#ffffff}</style><path d="M96 128a128 128 0 1 1 256 0A128 128 0 1 1 96 128zM0 482.3C0 383.8 79.8 304 178.3 304h91.4C368.2 304 448 383.8 448 482.3c0 16.4-13.3 29.7-29.7 29.7H29.7C13.3 512 0 498.7 0 482.3zM609.3 512H471.4c5.4-9.4 8.6-20.3 8.6-32v-8c0-60.7-27.1-115.2-69.8-151.8c2.4-.1 4.7-.2 7.1-.2h61.4C567.8 320 640 392.2 640 481.3c0 17-13.8 30.7-30.7 30.7zM432 256c-31 0-59-12.6-79.3-32.9C372.4 196.5 384 163.6 384 128c0-26.8-6.6-52.1-18.3-74.3C384.3 40.1 407.2 32 432 32c61.9 0 112 50.1 112 112s-50.1 112-112 112z"/></svg>
                Customers</a>';
                }
                
                if ($_SESSION['UGroup_id'] == 1 OR $_SESSION['UGroup_id'] == 2 OR $_SESSION['UGroup_id'] == 3 OR $_SESSION['UGroup_id'] == 5){
                echo '
                <a href="loans_search.php">
                <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 576 512"><style>svg{fill:#ffffff}</style><path d="M0 112.5V422.3c0 18 10.1 35 27 41.3c87 32.5 174 10.3 261-11.9c79.8-20.3 159.6-40.7 239.3-18.9c23 6.3 48.7-9.5 48.7-33.4V89.7c0-18-10.1-35-27-41.3C462 15.9 375 38.1 288 60.3C208.2 80.6 128.4 100.9 48.7 79.1C25.6 72.8 0 88.6 0 112.5zM288 352c-44.2 0-80-43-80-96s35.8-96 80-96s80 43 80 96s-35.8 96-80 96zM64 352c35.3 0 64 28.7 64 64H64V352zm64-208c0 35.3-28.7 64-64 64V144h64zM512 304v64H448c0-35.3 28.7-64 64-64zM448 96h64v64c-35.3 0-64-28.7-64-64z"/></svg>
                Loans</a>';
                }
                
                 if ($_SESSION['UGroup_id'] == 1 OR $_SESSION['UGroup_id'] == 2 OR $_SESSION['UGroup_id'] == 3 OR $_SESSION['UGroup_id'] == 4){
                echo '
                <a href="empl_curr.php">
                <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 448 512"><style>svg{fill:#ffffff}</style><path d="M224 256A128 128 0 1 1 224 0a128 128 0 1 1 0 256zM209.1 359.2l-18.6-31c-6.4-10.7 1.3-24.2 13.7-24.2H224h19.7c12.4 0 20.1 13.6 13.7 24.2l-18.6 31 33.4 123.9 36-146.9c2-8.1 9.8-13.4 17.9-11.3c70.1 17.6 121.9 81 121.9 156.4c0 17-13.8 30.7-30.7 30.7H285.5c-2.1 0-4-.4-5.8-1.1l.3 1.1H168l.3-1.1c-1.8 .7-3.8 1.1-5.8 1.1H30.7C13.8 512 0 498.2 0 481.3c0-75.5 51.9-138.9 121.9-156.4c8.1-2 15.9 3.3 17.9 11.3l36 146.9 33.4-123.9z"/></svg>
                Employees</a>' ;
                 }
        
                if ($_SESSION['UGroup_id'] == 1 OR $_SESSION['UGroup_id'] == 2)/* $_SESSION['log_report'] == 1 OR */{
					echo '<a';
					if ($tab_no == 5) echo ' id="tab_selected"';
					echo ' href="rep_incomes.php">
                    <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 384 512"><style>svg{fill:#ffffff}</style><path d="M64 464c-8.8 0-16-7.2-16-16V64c0-8.8 7.2-16 16-16H224v80c0 17.7 14.3 32 32 32h80V448c0 8.8-7.2 16-16 16H64zM64 0C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64V154.5c0-17-6.7-33.3-18.7-45.3L274.7 18.7C262.7 6.7 246.5 0 229.5 0H64zm56 256c-13.3 0-24 10.7-24 24s10.7 24 24 24H264c13.3 0 24-10.7 24-24s-10.7-24-24-24H120zm0 96c-13.3 0-24 10.7-24 24s10.7 24 24 24H264c13.3 0 24-10.7 24-24s-10.7-24-24-24H120z"/></svg>
                    Reports</a>';
				}
                if ($_SESSION['UGroup_id'] == 1 OR $_SESSION['UGroup_id'] == 2 ){
                echo '
                <a href="books_expense.php">
                <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 384 512"><style>svg{fill:#ffffff}</style><path d="M64 0C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64H320c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64zM96 64H288c17.7 0 32 14.3 32 32v32c0 17.7-14.3 32-32 32H96c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32zm32 160a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM96 352a32 32 0 1 1 0-64 32 32 0 1 1 0 64zM64 416c0-17.7 14.3-32 32-32h96c17.7 0 32 14.3 32 32s-14.3 32-32 32H96c-17.7 0-32-14.3-32-32zM192 256a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm64-64a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM288 448a32 32 0 1 1 0-64 32 32 0 1 1 0 64z"/></svg>
                Accounting</a>
                ';
                }
        
				if ( $_SESSION['UGroup_id'] == 1)/* $_SESSION['log_admin'] == 1 OR */{
					echo '<a';
					if ($tab_no == 6) echo ' id="tab_selected"';
					echo ' href="set_basic.php">
                    <svg xmlns="http://www.w3.org/2000/svg" height="1em" viewBox="0 0 640 512"><style>svg{fill:#ffffff}</style><path d="M308.5 135.3c7.1-6.3 9.9-16.2 6.2-25c-2.3-5.3-4.8-10.5-7.6-15.5L304 89.4c-3-5-6.3-9.9-9.8-14.6c-5.7-7.6-15.7-10.1-24.7-7.1l-28.2 9.3c-10.7-8.8-23-16-36.2-20.9L199 27.1c-1.9-9.3-9.1-16.7-18.5-17.8C173.9 8.4 167.2 8 160.4 8h-.7c-6.8 0-13.5 .4-20.1 1.2c-9.4 1.1-16.6 8.6-18.5 17.8L115 56.1c-13.3 5-25.5 12.1-36.2 20.9L50.5 67.8c-9-3-19-.5-24.7 7.1c-3.5 4.7-6.8 9.6-9.9 14.6l-3 5.3c-2.8 5-5.3 10.2-7.6 15.6c-3.7 8.7-.9 18.6 6.2 25l22.2 19.8C32.6 161.9 32 168.9 32 176s.6 14.1 1.7 20.9L11.5 216.7c-7.1 6.3-9.9 16.2-6.2 25c2.3 5.3 4.8 10.5 7.6 15.6l3 5.2c3 5.1 6.3 9.9 9.9 14.6c5.7 7.6 15.7 10.1 24.7 7.1l28.2-9.3c10.7 8.8 23 16 36.2 20.9l6.1 29.1c1.9 9.3 9.1 16.7 18.5 17.8c6.7 .8 13.5 1.2 20.4 1.2s13.7-.4 20.4-1.2c9.4-1.1 16.6-8.6 18.5-17.8l6.1-29.1c13.3-5 25.5-12.1 36.2-20.9l28.2 9.3c9 3 19 .5 24.7-7.1c3.5-4.7 6.8-9.5 9.8-14.6l3.1-5.4c2.8-5 5.3-10.2 7.6-15.5c3.7-8.7 .9-18.6-6.2-25l-22.2-19.8c1.1-6.8 1.7-13.8 1.7-20.9s-.6-14.1-1.7-20.9l22.2-19.8zM112 176a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM504.7 500.5c6.3 7.1 16.2 9.9 25 6.2c5.3-2.3 10.5-4.8 15.5-7.6l5.4-3.1c5-3 9.9-6.3 14.6-9.8c7.6-5.7 10.1-15.7 7.1-24.7l-9.3-28.2c8.8-10.7 16-23 20.9-36.2l29.1-6.1c9.3-1.9 16.7-9.1 17.8-18.5c.8-6.7 1.2-13.5 1.2-20.4s-.4-13.7-1.2-20.4c-1.1-9.4-8.6-16.6-17.8-18.5L583.9 307c-5-13.3-12.1-25.5-20.9-36.2l9.3-28.2c3-9 .5-19-7.1-24.7c-4.7-3.5-9.6-6.8-14.6-9.9l-5.3-3c-5-2.8-10.2-5.3-15.6-7.6c-8.7-3.7-18.6-.9-25 6.2l-19.8 22.2c-6.8-1.1-13.8-1.7-20.9-1.7s-14.1 .6-20.9 1.7l-19.8-22.2c-6.3-7.1-16.2-9.9-25-6.2c-5.3 2.3-10.5 4.8-15.6 7.6l-5.2 3c-5.1 3-9.9 6.3-14.6 9.9c-7.6 5.7-10.1 15.7-7.1 24.7l9.3 28.2c-8.8 10.7-16 23-20.9 36.2L315.1 313c-9.3 1.9-16.7 9.1-17.8 18.5c-.8 6.7-1.2 13.5-1.2 20.4s.4 13.7 1.2 20.4c1.1 9.4 8.6 16.6 17.8 18.5l29.1 6.1c5 13.3 12.1 25.5 20.9 36.2l-9.3 28.2c-3 9-.5 19 7.1 24.7c4.7 3.5 9.5 6.8 14.6 9.8l5.4 3.1c5 2.8 10.2 5.3 15.5 7.6c8.7 3.7 18.6 .9 25-6.2l19.8-22.2c6.8 1.1 13.8 1.7 20.9 1.7s14.1-.6 20.9-1.7l19.8 22.2zM464 304a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"/></svg>
                    Settings</a>';
				}
            echo '    
            </nav>
            <div class="toggleMenuIcon">
                <a onclick="showMmenu()" href="#"><img class="openTBicon" src="ico/tMenuIconpOpen.png"> <img class="closeTBicon" src="ico/tMenuIconpClose.png"></a>
            </div>
        </section>
        </div>
        
        ';
        
        

		/* echo '
		<!-- MENU TABS -->
		<div id="menu_tabs">
			<ul>
				<li';
				if ($tab_no == 1) echo ' id="tab_selected"';
				echo '><a href="start.php"><i class="fa fa-tachometer fa-fw"></i> Dashboard</a></li>
				<li';
				if ($tab_no == 2) echo ' id="tab_selected"';
				echo '><a href="cust_search.php"><i class="fa fa-group fa-fw"></i> Customers</a></li>
				<li';
				if ($tab_no == 3) echo ' id="tab_selected"';
				echo '><a href="loans_search.php"><i class="fa fa-percent fa-fw"></i> Loans</a></li>
				<li';
				if ($tab_no == 4) echo ' id="tab_selected"';
				echo '><a href="books_expense.php"><i class="fa fa-calculator fa-fw"></i> Accounting</a></li>
				<li';
				if ($tab_no == 7) echo ' id="tab_selected"';
				echo '><a href="empl_curr.php"><i class="fa fa-male fa-fw"></i> Employees</a></li>';

				if ($_SESSION['log_report'] == 1){
					echo '<li';
					if ($tab_no == 5) echo ' id="tab_selected"';
					echo '><a href="rep_incomes.php"><i class="fa fa-line-chart fa-fw"></i> Reports</a></li>';
				}

				if ($_SESSION['log_admin'] == 1){
					echo '<li';
					if ($tab_no == 6) echo ' id="tab_selected"';
					echo '><a href="set_basic.php"><i class="fa fa-wrench fa-fw"></i> Settings</a></li>';
				}
			echo '</ul>
		</div>'; */
        
        
	}

/**
	* Generate a Javascript alert message
	* @param string text : Message text
	*/
	function showMessage($text) {
		echo '<script language=javascript>
						alert(\''.$text.'\')
					</script>';
	}

/**
	* Calculate a given customer's savings account balance
	* @return int savbal : Current savings account balance for given customer
	*/
	function getSavingsBalance($db_link, $cust_id){
		$sql_savbal = "SELECT savbal_balance FROM savbalance WHERE cust_id = $cust_id";
		$query_savbal = mysqli_query($db_link, $sql_savbal);
		checkSQL($db_link, $query_savbal);

		$savbal = mysqli_fetch_assoc($query_savbal);

		return $savbal['savbal_balance'];
	}

	/**
		* Calculate a given customer's fixed savings
		* @return int savfixed : Balance of currently fixed savings for given customer
		*/
		function getSavingsFixed($db_link, $cust_id){
			$sql_savfixed = "SELECT savbal_fixed FROM savbalance WHERE cust_id = $cust_id";
			$query_savfixed = mysqli_query($db_link, $sql_savfixed);
			checkSQL($db_link, $query_savfixed);

			$savfixed = mysqli_fetch_assoc($query_savfixed);

			return $savfixed['savbal_fixed'];
		}

/**
	* Update savings account balance for SPECIFIC customer
	*/
	function updateSavingsBalance($db_link, $cust_id){
		$timestamp = time();
		$sql_savbal_upd = "UPDATE savbalance SET savbal_balance = (SELECT SUM(sav_amount) FROM savings WHERE cust_id = $cust_id), savbal_fixed = (SELECT SUM(sav_amount) FROM savings WHERE cust_id = $cust_id and sav_fixed > $timestamp) WHERE cust_id = $cust_id";
		$query_savbal_upd = mysqli_query($db_link, $sql_savbal_upd);
		checkSQL($db_link, $query_savbal_upd, $db_link);
	}

/**
	* Update savings account balance for ALL customers
	*/
	function updateSavingsBalanceAll($db_link){
		$sql_savbal_upd_all = "UPDATE savbalance SET savbalance.savbal_balance = (SELECT SUM(savings.sav_amount) FROM savings WHERE savings.cust_id = savbalance.cust_id)";
		$query_savbal_upd_all = mysqli_query($db_link, $sql_savbal_upd_all);
		checkSQL($db_link, $query_savbal_upd_all, $db_link);
	}

/**
	* Calculate balances for a specific loan
	* @return array $loanbal : Array with principal balance,
	*/
	function getLoanBalance($db_link, $loan_id){
		//Select Loan Balance from LTRANS
		$sql_balances = "SELECT ltrans_principaldue, ltrans_interestdue, ltrans_principal, ltrans_interest FROM ltrans WHERE ltrans.loan_id = '$loan_id'";
		$query_balances = mysqli_query($db_link, $sql_balances);
		checkSQL($db_link, $query_balances, $db_link);

		//Calculate outstanding balances
		$loan_balances = array(
			"pdue" => 0,
			"idue" => 0,
			"ppaid" => 0,
			"ipaid" => 0,
			"balance" => 0
		);
		while ($row_balances = mysqli_fetch_assoc($query_balances)){
			$loan_balances['pdue'] = $loan_balances['pdue'] + $row_balances['ltrans_principaldue'];
			$loan_balances['idue'] = $loan_balances['idue'] + $row_balances['ltrans_interestdue'];
			$loan_balances['ppaid'] = $loan_balances['ppaid'] + $row_balances['ltrans_principal'];
			$loan_balances['ipaid'] = $loan_balances['ipaid'] + $row_balances['ltrans_interest'];
		}
		$loan_balances['balance'] = ($loan_balances['pdue'] + $loan_balances['idue']) - ($loan_balances['ppaid'] + $loan_balances['ipaid']);

		return $loan_balances;
	}

/**
	* Calculate current customer's share account balance
	* @return int share_balace : Current share account balance
	*/
	function getShareBalance($db_link, $cust_id){
		$sql_sharebal = "SELECT share_amount, share_value FROM shares WHERE cust_id = $cust_id";
		$query_sharebal = mysqli_query($db_link, $sql_sharebal);
		checkSQL($db_link, $query_sharebal, $db_link);
		$sharebal = array("amount" => "0", "value" => "0");
		while($row_sharebal = mysqli_fetch_assoc($query_sharebal)){
			$sharebal['amount'] = $sharebal['amount'] + $row_sharebal['share_amount'];
			$sharebal['value'] = $sharebal['value'] + $row_sharebal['share_value'];
		}
		return $sharebal;
	}

/**
	* Get current customer's details
	* @return array result_cust : Associative array with the details of the current customer
	*/
	function getCustomer($db_link, $custID){
		$sql_cust = "SELECT * FROM customer LEFT JOIN custsex ON customer.custsex_id = custsex.custsex_id LEFT JOIN custmarried ON customer.custmarried_id = custmarried.custmarried_id LEFT JOIN custsick ON customer.custsick_id = custsick.custsick_id LEFT JOIN user ON customer.user_id = user.user_id WHERE cust_id = '$custID'";
		$query_cust = mysqli_query($db_link, $sql_cust);
		checkSQL($db_link, $query_cust, $db_link);
		$result_cust = mysqli_fetch_assoc($query_cust);

		return $result_cust;
	}

/**
	* Get all customers except current one
	* @return array query_custother : Array with the result of the SQL query
	*/
	function getCustOther($db_link){
		$sql_custother = "SELECT * FROM customer LEFT JOIN custsex ON custsex.custsex_id = customer.custsex_id WHERE cust_id NOT IN (0, $_SESSION[cust_id]) ORDER BY cust_id";
		$query_custother = mysqli_query($db_link, $sql_custother);
		checkSQL($db_link, $query_custother, $db_link);

		return $query_custother;
	}

/**
	* Get all active customers
	* @return array query_custact : Array with the result of the SQL query
	*/
	function getCustAct($db_link){
		$sql_custact = "SELECT * FROM customer LEFT JOIN custsex ON custsex.custsex_id = customer.custsex_id WHERE cust_id != 0 AND cust_active = 1 ORDER BY cust_id";
		$query_custact = mysqli_query($db_link, $sql_custact);
		checkSQL($db_link, $query_custact, $db_link);

		return $query_custact;
	}

/**
	* Get all inactive customers
	* @return array query_custinact : Array with the result of the SQL query
	*/
	function getCustInact($db_link){
		$sql_custinact = "SELECT * FROM customer LEFT JOIN custsex ON custsex.custsex_id = customer.custsex_id WHERE cust_id != 0 AND cust_active != 1 ORDER BY cust_id";
		$query_custinact = mysqli_query($db_link, $sql_custinact);
		checkSQL($db_link, $query_custinact, $db_link);

		return $query_custinact;
	}

/**
	* Get all customers
	* @return array query_custall : Array with the result of the SQL query
	*/
	function getCustAll($db_link){
		$sql_custall = "SELECT * FROM customer LEFT JOIN custsex ON custsex.custsex_id = customer.custsex_id WHERE cust_id !=0";
		$query_custall = mysqli_query($db_link, $sql_custall);
		checkSQL($db_link, $query_custall, $db_link);

		return $query_custall;
	}

/**
	* Get customers with overdue subscription fee
	* @return array query_custoverdue : Array with the result of the SQL query
	*/
	function getCustOverdue($db_link){
		$last_subscr = time() - convertDays(365); //Seconds for 365 days
		$sql_custoverdue = "SELECT * FROM customer WHERE cust_active = 1 AND cust_lastsub < $last_subscr ORDER BY cust_lastsub, cust_id";
		$query_custoverdue = mysqli_query($db_link, $sql_custoverdue);
		checkSQL($db_link, $query_custoverdue, $db_link);

		return $query_custoverdue;
	}

/**
	* Build new customer number
	* @return varchar custNo :  Newly build customer number
	*/
	function buildCustNo($db_link){
		// Determine biggest customer ID
		$sql_maxID = "SELECT MAX(cust_id) AS maxid FROM customer";
		$query_maxID = mysqli_query($db_link, $sql_maxID);
		checkSQL($db_link, $query_maxID);
		$result_maxID = mysqli_fetch_array($query_maxID);

		// Read customer number format
		$cnParts = explode("%", $_SESSION['set_cno']);
		$cnCount = count($cnParts);

		// Build customer number
		$i = 0;
		$custNo = "";
		for ($i = 1; $i < $cnCount; $i++) {
			switch($cnParts[$i]){
				case "N":
					$custNo = $custNo.($result_maxID['maxid'] + 1);
					break;
				case "Y":
					$custNo = $custNo.date("Y",time());
					break;
				case "M":
					$custNo = $custNo.date("m",time());
					break;
				case "D":
					$custNo = $custNo.date("d",time());
					break;
				default:
					$custNo = $custNo.$cnParts[$i];
			}
		}

		// Return customer number
		return $custNo;
	}

/**
	* Get current employee
	* @return array result_empl :  Associative array with the details of the current employee
	*/
	function getEmployee($db_link, $empl_id){
		$sql_empl = "SELECT * FROM employee LEFT JOIN user ON employee.empl_id = user.empl_id WHERE employee.empl_id = $empl_id";
		$query_empl = mysqli_query($db_link, $sql_empl);
		checkSQL($db_link, $query_empl, $db_link);
		$result_empl = mysqli_fetch_assoc($query_empl);

		return $result_empl;
	}

/**
	* Get all current employees
	* @return array query_emplcurr : Array with the result of the SQL query
	*/
	function getEmplCurr($db_link){
		$timestamp = time();
		$sql_emplcurr = "SELECT * FROM employee LEFT JOIN emplsex ON employee.emplsex_id = emplsex.emplsex_id LEFT JOIN emplmarried ON employee.emplmarried_id = emplmarried.emplmarried_id WHERE empl_id != 0 AND (empl_out > $timestamp OR empl_out IS NULL) ORDER BY empl_id";
		$query_emplcurr = mysqli_query($db_link, $sql_emplcurr);
		checkSQL($db_link, $query_emplcurr, $db_link);

		return $query_emplcurr;
	}

/**
	* Get all past employees
	* @return array query_emplpast : Array with the result of the SQL query
	*/
	function getEmplPast($db_link){
		$timestamp = time();
		$sql_emplpast = "SELECT * FROM employee LEFT JOIN emplsex ON employee.emplsex_id = emplsex.emplsex_id LEFT JOIN emplmarried ON employee.emplmarried_id = emplmarried.emplmarried_id WHERE empl_id != 0 AND empl_out < $timestamp ORDER BY empl_id";
		$query_emplpast = mysqli_query($db_link, $sql_emplpast);
		checkSQL($db_link, $query_emplpast, $db_link);

		return $query_emplpast;
	}

/**
	* Build new employee number
	* @return varchar emplNo :  Newly build employee number
	*/
	function buildEmplNo($db_link){
		// Determine biggest employee ID
		$sql_maxID = "SELECT MAX(empl_id) AS maxid FROM employee";
		$query_maxID = mysqli_query($db_link, $sql_maxID);
		checkSQL($db_link, $query_maxID, $db_link);
		$result_maxID = mysqli_fetch_array($query_maxID);

		// Read employee number format
		$enParts = explode("%", $_SESSION['set_eno']);
		$enCount = count($enParts);

		// Build customer number
		$i = 0;
		$emplNo = "";
		for ($i = 1; $i < $enCount; $i++) {
			switch($enParts[$i]){
				case "N":
					$emplNo = $emplNo.($result_maxID['maxid'] + 1);
					break;
				case "Y":
					$emplNo = $emplNo.date("Y",time());
					break;
				case "M":
					$emplNo = $emplNo.date("m",time());
					break;
				case "D":
					$emplNo = $emplNo.date("d",time());
					break;
				default:
					$emplNo = $emplNo.$enParts[$i];
			}
		}

		// Return employee number
		return $emplNo;
	}

/**
	* Get all overdue Loan Instalments
	* @return array query_overdue : Array with the result of the SQL query
	*/
	function getLtransOverdue($db_link){
		$timestamp = time();
		$sql_overdue = "SELECT * FROM ltrans LEFT JOIN loans ON ltrans.loan_id = loans.loan_id LEFT JOIN customer ON loans.cust_id = customer.cust_id WHERE ltrans_due <= $timestamp AND ltrans_date IS NULL AND loanstatus_id = 2 ORDER BY ltrans_due";
		$query_overdue = mysqli_query($db_link, $sql_overdue);
		checkSQL($db_link, $query_overdue, $db_link);
		return $query_overdue;
	}

/**
	* Get all securities which belong to a given loan
	* @return array securities : Array with the result of the SQL query
	*/
	function getLoanSecurities($db_link, $loan_id){
		$sql_secur = "SELECT * FROM securities WHERE loan_id = $loan_id";
		$query_secur = mysqli_query($db_link, $sql_secur);
		checkSQL($db_link, $query_secur);
		$securities = array();
		while ($row_secur = mysqli_fetch_assoc($query_secur)) $securities[] = $row_secur;
		return $securities;
	}

/**
	* Get details of a given loan security
	* @return array result_sec : Array with the result of the SQL query
	*/
	function getSecurity($db_link, $sec_id){
		$sql_sec = "SELECT * FROM securities LEFT JOIN loans ON securities.loan_id = loans.loan_id LEFT JOIN customer ON securities.cust_id = customer.cust_id WHERE sec_id = $sec_id";
		$query_sec = mysqli_query($db_link, $sql_sec);
		checkSQL($db_link, $query_sec);
		$result_sec = mysqli_fetch_assoc($query_sec);
		return $result_sec;
	}

?>
